require( "quest/m1_diner/convout.lua" );
combine_speech_tables();

function bernie_in_diner()
	return game:Get( "suspicious_done" ) == 1 and game:Get( "found_bernie" ) ~= 1;
	--return true;
end

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

function diner_intro(flo)
	run_super_conversation(flo, "quip_automatic_intro");
	run_super_conversation(flo, "conv_diner_intro");
	--coroutine.yield(RESUME.ON_CLICK);
	--coroutine.yield(RESUME.ON_MOUSE_NOT_DOWN);
	--scene:DisplayFlash("flash/diner.swf");
	--delay(1);
	--scene:Spawn(coffee_spill_spec);
	--delay(1);
	--wait_subscene();
	
	game:Set("first_time_diner", 1);
	
	run_super_conversation(flo, "quip_automatic_spill");
	
	flo:Face(DIR.SE);
	flo:SetMode(MODE.FOLLOWCLICKS);
	
	sfx:PlaySFX("audio/sfx/tutorial_popup.ogg");
	scene:Spawn(small_dialog_spec);
	scene[small_dialog_spec.name]:Say("text_tutorial_spill");
end

function set_flo_settle_bubble()
	scene.FLO:ModifySaySpec { mouth_in_actor = { x = -30, y = -145 } }
	scene.FLO:ModifySaySpec 
		{ 
			bubble_0 = bubble_b0_spec,
			bubble_1 = bubble_b1_spec,
			bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_FORCEFLIP + BUBBLE.BUBBLE_FORCEVFLIP 
		};
end

function set_flo_dinertoon_bubble()
	prepare_actor_text(scene.FLO, flo_text_spec);
end

flo_spec =
{
	name = "FLO";
	--point_at_name = "obj_flo";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);
		
		set_flo_settle_bubble();
		
		actor:JumpToNamedPoint("florida");
		actor:FaceNow(DIR.E);
	
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:WalkTo("florida_walkto");
		wait_walkto();
		
		actor:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		
		actor:WalkTo("flo_walkto");
		wait_walkto();
		
		actor:Face(DIR.SE);
		
		if game:Get("first_time_diner") ~= 1 then
			actor:StartProc(diner_intro);
		elseif bernie_in_diner() and game:Get("seen_bernie_in_diner") < 1 then
			run_super_conversation(actor, "conv_flo_bernie_A");
			game:Set("seen_bernie_in_diner", 1);
			actor:SetMode(MODE.FOLLOWCLICKS);
		elseif game:Get( "have_safe_combo" ) == 1 and game:Get("safe_closed") == 1 then
			run_super_conversation(actor, "conv_got_code");
			actor:SetMode(MODE.FOLLOWCLICKS);
		else
			actor:SetMode(MODE.FOLLOWCLICKS);
		end
	end;
	
	on_arrive = function(flo, flo2)
		if game:Get("cleaned_coffee_spill") < 1 then
			convproc("FLO", "conv_flo_spill");
		elseif game:Get("found_phone") < 1 then
			convproc("FLO", "conv_flo_phone");
		elseif game:Get("florida_tutorial") < 1 then
			convproc("FLO", "conv_flo_leave");
		elseif bernie_in_diner() then
			convproc("FLO", "conv_flo_bernie_B");
		elseif game:Get("safe_closed") == 1 then
			if quest_complete("figure_out_clues") then
				convproc("FLO", "conv_grandma_got_code");
			else
				convproc("FLO", "conv_flo_need_code");
			end
		elseif quest_complete("rings") then
			convproc("FLO", "conv_flo_got_rings");
		else
			convproc("FLO", "conv_flo_reentry");
		end
	end;
	
	on_use_inv = function(item, flo, flo2)
		if item == "mop" then
			convproc("FLO", "misused_mop");
			return RESPONSE.INV_UNHANDLED;
		else
			flo_inv_generic(flo, item);
			return RESPONSE.INV_HANDLED;
		end
	end
};

function talk_to_gran(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("cleaned_coffee_spill") < 1 then
		run_super_conversation(flo, "conv_grandma_coffee");
	elseif game:Get("found_phone") < 1 then
		run_super_conversation(flo, "conv_grandma_phone");
	elseif game:Get("florida_tutorial") < 1 then
		run_super_conversation(flo, "conv_grandma_leave");
	elseif bernie_in_diner() then
		run_super_conversation(flo, "conv_grandma_bernie");
	elseif game:Get("safe_closed") == 1 then
		if game:Get( "have_safe_combo" ) == 1 then
			run_super_conversation(flo, "conv_grandma_got_code");
		else
			run_super_conversation(flo, "conv_grandma_need_code");
		end
	elseif quest_complete("rings") then
		run_super_conversation(flo, "conv_grandma_got_rings");
	else
		run_super_conversation(flo, "conv_grandma_reentry");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

gran_spec = 
{
	name = "GRAN";
	--point_at_name = "obj_gran";
	halo = "quest/objects/gran";
	
	command = function(actor)
		prepare_actor_text(actor, gran_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(gran_speed);
		
		if game:Get("first_time_diner") < 1 or math.random(1,3) == 2 then
			actor:JumpToNamedPoint("gran_pose2");
			actor:LoadAnimFile("anim/gran/pose2");
			actor:FaceNow(DIR.W);
			actor:PlayAnim("DoStandW");
		else
			actor:JumpToNamedPoint("gran_pose1");
			actor:LoadAnimFile("anim/gran/pose1");
			actor:FaceNow(DIR.S);
			actor:PlayAnim("DoStandS");
			actor:ModifySaySpec{ mouth_in_actor = { x = 0, y = -90 } };
		end
	end;
	
	on_arrive = function(flo, gran)
		flo:StartProc(talk_to_gran);
	end;
	
	on_use_inv = function(item, flo, gran)
		if item == "mop" then
			convproc("FLO", "quip_gran_mop");
		else
			convproc("FLO", "quip_grandma_reject");
		end
	end;
};

function talk_to_cookie(flo)
	flo:SetMode(MODE.CUTSCENE);
	cookie_talk_begin();
	if game:Get("cleaned_coffee_spill") < 1 then
		run_super_conversation(flo, "conv_cookie_spill");
	elseif game:Get("found_phone") < 1 then
		run_super_conversation(flo, "conv_cookie_phone");
	elseif game:Get("florida_tutorial") < 1 then
		run_super_conversation(flo, "conv_cookie_leave");
	elseif bernie_in_diner() then
		run_super_conversation(flo, "conv_cookie_bernie");
	elseif game:Get("safe_closed") == 1 then
		if game:Get( "have_safe_combo" ) == 1 then
			run_super_conversation(flo, "conv_cookie_got_code");
		else
			run_super_conversation(flo, "conv_cookie_need_code");
		end
	elseif quest_complete("rings") then
		run_super_conversation(flo, "conv_cookie_got_rings");
	else
		run_super_conversation(flo, "conv_cookie_reentry");
	end
	cookie_talk_end();
	flo:SetMode(MODE.FOLLOWCLICKS);
end

cookie_anim_table = 
{
	"anim/cookie/stand";
};

function cookie_talk_begin()
	scene.COOKIE:DumpAnimFile("anim/cookie/stand");
	scene.COOKIE:LoadAnimFile("anim/cookie/talk");
	scene.COOKIE:PlayAnim("DoStandW");
end

function cookie_talk_end()
	scene.COOKIE:DumpAnimFile("anim/cookie/talk");
	scene.COOKIE:LoadAnimFile("anim/cookie/stand");
	scene.COOKIE:PlayAnim("DoStandW");
end

function use_inv_on_cookie(item, flo)
	if item == "mop" then
		flo:StartProc(
			function(flo)
				flo:SetMode(MODE.CUTSCENE);
				cookie_talk_begin();
				run_super_conversation(flo, "quip_cookie_mop");
				cookie_talk_end();
				flo:SetMode(MODE.FOLLOWCLICKS);
			end);
	else
		flo:StartProc(
			function(flo)
				flo:SetMode(MODE.CUTSCENE);
				cookie_talk_begin();
				run_super_conversation(flo, "quip_cookie_reject");
				cookie_talk_end();
				flo:SetMode(MODE.FOLLOWCLICKS);
			end);
	end
	
end

cookie_spec = 
{
	name = "COOKIE";
	--point_at_name = "obj_cookie";
	halo = "quest/objects/cookie";
	anim = cookie_anim_table;
	--gfx = { anim = "anim/m1_diner/cookiestir" };
	
	command = function(actor)
		prepare_actor_text(actor, cookie_text_spec);
		actor:SetDepthValue(2);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("cookie");
		actor:FaceNow(DIR.W);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(cookie_speed);
			
	end;
	
	on_arrive = function(flo, cookie)
		flo:StartProc(talk_to_cookie);
	end;
	
	on_use_inv = function(item, flo, cookie)
		use_inv_on_cookie(item, flo);
	end;
};

bernie_anim_table = 
{
	"anim/bernie/diner",
};

bernie_spec = 
{
	name = "BERNIE";
	halo = "quest/objects/bernie";
	anim = bernie_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, bernie_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("bernie");
		actor:FaceNow(DIR.W);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(bernie_speed);
	end;
	
	on_arrive = function(flo, bernie)
		game:Set( "found_bernie", 1 );
		flo:StartProc(confrontbernie);		
	end;
};

function confrontbernie(flo)
	flo:SetMode(MODE.CUTSCENE);
	-- play appropriate cinematic
	scene:DisplayFlash("flash/wedding_ring_discovery_intro.swf");
	wait_subscene();
	delay(4);
	scene.BERNIE:Expire();
	scene.SAFE:LoadImage("safe_closed");
	game:Set("safe_closed", 1);
	
	delay(10);
	
	run_super_conversation(flo, "conv_rings_locked");
	
	complete_quest("find_bernie", false);
	add_quest("rings_locked", false);
	add_quest("find_code_paper");
	wait_subscene();
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function talk_to_dinertoon1(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	--flo:WalkTo("dinertoon1_walkto");
	--wait_walkto();
	
	flo:Face(DIR.SE);
	
	--set_flo_dinertoon_bubble();
	
	if game:Get("cleaned_coffee_spill") < 1 then
		run_super_conversation(flo, "conv_rosie_spill");
	elseif game:Get("found_phone") < 1 then
		run_super_conversation(flo, "conv_rosie_phone");
	elseif game:Get("florida_tutorial") < 1 then
		run_super_conversation(flo, "conv_rosie_leave");
	elseif bernie_in_diner() then
		run_super_conversation(flo, "conv_rosie_bernie");
	elseif game:Get("safe_closed") == 1 then
		run_super_conversation(flo, "conv_rosie_need_code");
	else
		run_super_conversation(flo, "conv_rosie_reentry");
	end
	
	--flo:WalkTo("flo_walkto");
	--wait_walkto();
	
	--set_flo_settle_bubble();
	
	flo:Face(DIR.E);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

dinertoon1_anim_table = 
{
	"anim/dinertoon1/stand",
	"anim/dinertoon1/talkw",
};

dinertoon1_spec = 
{
	name = "ROSIE";
	--point_at_name = "obj_dinertoon1";
	halo = "quest/objects/dinertoon1";
	anim = dinertoon1_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, dinertoon1_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("dinertoon1");
		actor:FaceNow(DIR.W);
		--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(dinertoon1_speed);
		actor:SetDepthValue(520);
	end;
	
	on_arrive = function(flo, dinertoon1)
		flo:StartProc(talk_to_dinertoon1);
	end;
	
	on_use_inv = function(item, flo, dinertoon1)
		convproc("FLO", "quip_regular_reject");
	end;
};

-- AG 081029 - don't have dinertoon 2 yet, put in when get art
function talk_to_dinertoon2(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:Face(DIR.SW);
	delay(30);
	if game:Get("cleaned_coffee_spill") < 1 then
		run_super_conversation(flo, "conv_senior_spill");
	elseif game:Get("found_phone") < 1 then
		run_super_conversation(flo, "conv_senior_phone");
	elseif bernie_in_diner() then
		run_super_conversation(flo, "conv_senior_bernie");
	elseif game:Get("safe_closed") == 1 then
		run_super_conversation(flo, "conv_senior_need_code");
	else
		run_super_conversation(flo, "conv_senior_leave");
	end
	flo:Face(DIR.E);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

dinertoon2_anim_table = 
{
	"anim/dinertoon2/stand",
	"anim/dinertoon2/talkw",
};

dinertoon2_spec = 
{
	name = "SENIOR";
	halo = "quest/objects/dinertoon2";
	anim = dinertoon2_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, dinertoon2_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("dinertoon2");
		actor:FaceNow(DIR.E);
		--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetDepthValue(600);
		actor:SetWalkSpeed(dinertoon2_speed);
	end;
	
	on_arrive = function(flo, dinertoon2)
		flo:StartProc(talk_to_dinertoon2);
	end;
	
	on_use_inv = function(item, flo, dinertoon2)
		convproc("FLO", "quip_senior_reject");
	end;
};

function talk_to_dinertoon3(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:Face(DIR.SW);
	delay(30);
	conv_multiple(flo, "conv_hungryman_", "A", 3);
	flo:Face(DIR.E);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

dinertoon3_anim_table = 
{
	"anim/hal/diner",
};

dinertoon3_spec = 
{
	name = "HAL";
	halo = "quest/objects/hal";
	anim = dinertoon3_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, hal_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("dinertoon3");
		actor:FaceNow(DIR.W);
		--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetDepthValue(400);
		actor:SetWalkSpeed(hal_speed);
	end;
	
	on_arrive = function(flo, dinertoon3)
		flo:StartProc(talk_to_dinertoon3);
	end;
	
	on_use_inv = function(item, flo, dinertoon3)
		convproc("FLO", "quip_hungryman_reject");
	end;
};

function get_coffee_cup(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_pickup_coffee");
	scene.COFFEE_CUP:Expire();
	addInventory(inv_desc_coffeecup);
	game:Set("got_cofee_cup_from_diner", 1);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

coffee_cup_spec = 
{
	name = "COFFEE_CUP";
	--point_at_name = "obj_coffee_cup";
	gfx = { image = "coffee_cup" };
	halo = "coffee_cup";
	
	command = function(actor)
		actor:SetDepthValue(265);
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(get_coffee_cup);
	end;
};

coffee_pot_spec = 
{
	name = "COFFEE_POT";
	--point_at_name = "obj_coffee_pot";
	gfx = { image = "coffee_pot" };
	halo = "coffee_pot";
	
	command = function(actor)
		actor:SetDepthValue(260);
	end;
	
	on_arrive = function(flo, coffee_pot)
		if game:Get("got_cofee_cup_from_diner") > 0 then
			convproc("FLO", "quip_dont_need_coffee");
		else
			flo:StartProc(get_coffee_cup);
		end
	end;
};

function clean_coffee_spill(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene[small_dialog_spec.name]:Expire();
	run_super_conversation(flo, "quip_start_cleaning_coffee_spill");
	
	scene.COFFEE_SPILL:Expire();
	BAG_INV:RemoveInventory("mop");
	scene:Spawn(mop_spec);
	sfx:PlaySFX("audio/sfx/use_mop.ogg");
	run_super_conversation(flo, "quip_clean_spill");
	
	game:Set("cleaned_coffee_spill", 1);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

coffee_spill_spec = 
{
	name = "COFFEE_SPILL";
	--point_at_name = "obj_coffee_spill";
	gfx = { anim = "anim/m1_diner/spill" };
	--gfx = { image = "coffee_spill" };
	halo = "coffee_spill";
	
	command = function(actor)
		actor:SetDepthValue(255);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("Spill");
		wait_anim();
		scene.FLO:Signal();
	end;
	
	on_arrive = function(flo, coffee_spill)
		convproc("FLO", "quip_lookat_coffee_spill");
	end;
	
	on_use_inv = function(item, flo, coffee_spill)
		if item == "mop" then
			flo:StartProc(clean_coffee_spill);
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
};

function get_mop(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_pickup_mop");
	scene.MOP:Expire();
	addInventory(inv_desc_mop);
	sfx:PlaySFX("audio/sfx/tutorial_popup.ogg");
	scene[small_dialog_spec.name]:Say("text_tutorial_mop");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

mop_spec = 
{
	name = "MOP";
	--point_at_name = "obj_mop";
	gfx = { image = "mop" };
	halo = "mop";
	
	command = function(actor)
		actor:SetDepthValue(245);
	end;
	
	on_arrive = function(flo, mop)
		if game:Get("cleaned_coffee_spill") ~= 1 then
			flo:StartProc(get_mop);
		else
			convproc("FLO", "quip_dont_need_mop");
		end
	end;
};

function find_phone_in_purse(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_found_purse");
	game:SetString("purse_level", "level_one");
	game:Set("diner_drawer_open", 1);
	
	sfx:KillSFX();
	scene:ChainToSubScene("purse");
	wait_subscene();
	
	scene.DRAWER:LoadImage("drawer_closed");
	if game:Get("found_phone") == 1 then
		scene.DRAWER:DumpZone();
		scene:DisplayFlash("flash/opening_movie_part1_intro.swf");
		wait_subscene();
		
		--run_super_conversation(flo, "conv_write_stuff_on_napkin");
		-- display napkin here
		--scene:ChainToSubScene("napkin");
		napkin_button_click(flo);
		wait_subscene();
		
		scene:DisplayFlash("flash/opening_movie_part2_intro.swf");
		delay(1);
		scene:SetFadeColor { a = 1, r = 0, g = 0, b = 0 };
		delay(1);
		
		scene:SetFadeTarget { a = 0, r = 0, g = 0, b = 0 };
		scene:SetFadeSpeed(0.05);
		scene:SetMusicVolumeSpeed(0.05);
		
		spawn_button(napkin_button_spec);
		
		wait_fade();
		
		run_super_conversation(flo, "quip_automatic_begin");
		sfx:PlaySFX("audio/sfx/tutorial_popup.ogg");
		scene:Spawn(small_dialog_spec);
		scene[small_dialog_spec.name]:Say("text_tutorial_door");
		spawn_nav_arrow(to_florida_spec);
	else
		raise_hud();
		-- say something
		game:Set("diner_drawer_open", 0);
		scene.DRAWER.closed = true;
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

ambient1_spec =
{
	name = "AMBIENT1";
	gfx = { anim = "anim/m1_diner/ambient1" };
	
	command = function(actor)
		actor:SetDepthValue(236);
		actor:JumpToPoint{ x = -23, y = 12 };
		actor:PlayAnim("ambient1");
	end;
}

ambient2_spec =
{
	name = "AMBIENT2";
	gfx = { anim = "anim/m1_diner/ambient2" };
	
	command = function(actor)
		actor:SetDepthValue(236);
		actor:JumpToPoint{ x = -20, y = 10 };
		actor:PlayAnim("ambient2");
	end;
}

drawer_spec = 
{
	name = "DRAWER";
	--point_at_name = "obj_drawer";
	
	command = function(actor)
		actor:SetDepthValue(150);
		actor:LoadImage("drawer_closed");
		actor.closed = true;
		
		if game:Get("found_phone") ~= 1 then
			actor:LoadZone("drawer");
		end
	end;
	
	on_arrive = function(flo, drawer)
		
		if drawer.closed then
			drawer:LoadImage("drawer_open");
			sfx:PlaySFX("audio/sfx/drawer_open.ogg");
			drawer.closed = false;
		end
		
		if game:Get("cleaned_coffee_spill") == 1 then
			if game:Get("found_phone") ~= 1 then
				flo:StartProc(find_phone_in_purse);
			end
		else
			convproc("FLO", "quip_open_drawer_before_mop");
		end
	end;
};

phone_ring_spec = 
{
	name = "PHONE_RING";
	gfx = { anim = "anim/m1_diner/audiowave" };
	command = function(actor)
		actor:SetAlpha(0);
		actor:JumpToPoint { x = -22, y = 12 };
		local ring_counter = 0;
		while true do 
			if game:Get("diner_drawer_open") < 1 then
				if ring_counter > 3 then
					actor:SetAlpha(1);
				end
				actor:PlayAnim("DoAnim");
				sfx:PlaySFX("audio/sfx/phone_ring.ogg");
				wait_anim();
				actor:SetAlpha(0);
				delay(70);
				ring_counter = ring_counter + 1;
			else
				delay(1);
			end
		end
	end;
};

function gotoflorida(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("florida");
	wait_walkto();
	goto_scene(flo, "m1_florida");
end

to_florida_spec = 
{
	name = "TO_FLORIDA";
	halo = "to_florida";
	cursor = "cursor_arrow_w";
	goto_fn = gotoflorida;
}

function lookat_safe(flo)
	flo:SetMode(MODE.CUTSCENE);
	if ( game:Get( "found_bernie" ) == 1 ) and game:Get("safe_closed") == 1 then
		if game:Get( "have_safe_combo" ) == 1 then
			run_super_conversation(flo, "quip_safe_closed");
			scene:ChainToSubScene("m1_safe");
			wait_subscene();
		
			if game:Get("safe_closed") < 1 then
				scene.SAFE:LoadImage("safe_open");
			end
		
			if game:Get( "got_rings" ) == 1 and game:Get( "done_rings" ) ~= 1 then
				addInventory(inv_desc_rings);
				game:Set( "done_rings", 1 );
				run_super_conversation(flo, "quip_safe_got_rings");
				complete_quest("code_number", false);
				complete_quest("rings_locked", false);
				complete_quest("rings", false);
				game:EarnAward("avenue-flo_weddingrings");
				add_quest("got_rings");
				wait_subscene();
			else
				--run_super_conversation(flo, "quip_safe_need_code");
			end
		else
			run_super_conversation(flo, "quip_safe_need_code");
		end
	else	
		if game:Get("cleaned_coffee_spill") < 1 then
			run_super_conversation(flo, "quip_safe_spill");
		elseif game:Get("found_phone") < 1 then
			run_super_conversation(flo, "quip_safe_purse");
		else
			run_super_conversation(flo, "quip_safe_open");		
		end
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

safe_spec = 
{
	name = "SAFE";
	halo = "safe";
	
	command = function(actor)
		if game:Get("safe_closed") < 1 then
			actor:LoadImage("safe_open");
		else
			actor:LoadImage("safe_closed");
		end
	end;
	
	on_arrive = function(flo, safe)
		flo:StartProc(lookat_safe);
	end;
};

tutorial_dialog_spec = 
{
	name = "TUTORIAL_DIALOG";
	gfx = { image = "quest/shared/tutorial_dialog" };
	
	command = function(actor)
		actor:JumpToPoint { x = 110, y = -80 };
		actor:SetDepthValue(600);
		actor:ModifySaySpec
		{
			colour = { a = 1, r = 1, g = 1, b = 1 };
			y = 90,
			x = 35,
			w = 350,
			h = 300,
			bubble = false,
			outline_size = 0,
			anchor = ANCHOR.TOP,
			halign = HALIGN.LEFT,
		};
		
		actor:Say("text_tutorial_mop");
	end;
}

small_dialog_spec = 
{
	name = "TUTORIAL_DIALOG_SMALL";
	gfx = { image = "quest/shared/tutorial_dialog_small" };
	
	command = function(actor)
		actor:JumpToPoint { x = 200, y = 450 };
		actor:SetDepthValue(600);
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 };
			y = 50,
			x = 20,
			w = 370,
			h = 100,
			bubble = false,
			outline_size = 0,
			anchor = ANCHOR.CENTER,
			halign = HALIGN.CENTER,
		};
		
		actor:Say("text_tutorial_mop");
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		if IsCheatMode() then
			-- testing data
		end
		
		scene:SetRoomScale(300, 550, 0.8, 1.0);	--topline, bottomline, topscale, bottomscale
		
		if game:Get("new_game") < 1 then
			scene:DisplayFlash("flash/ave_flo_animatic_intro.swf");
			wait_subscene();	
			game:Set("new_game", 1);
		end
		
		if IsCheatMode() then
			--game:Set( "suspicious_done", 1);
			--game:Set( "found_bernie", 0);
			--game:Set( "found_bernie", 1 );
			--game:Set("safe_closed", 1);
			--game:Set( "have_safe_combo", 1 );
		end
		
		sfx:SetMusic("audio/music/dinermusic.ogg", true);
		
		fade_scene_up();
		
		if game:Get("found_phone") > 0 then
			spawn_nav_arrow(to_florida_spec);
		end
		
		if game:Get("got_cofee_cup_from_diner") < 1 then
			scene:Spawn(coffee_cup_spec);
		end
		
		if game:Get( "have_safe_combo" ) ~= 1 then
			scene:Spawn(dinertoon1_spec);
			scene:Spawn(dinertoon2_spec);
		end
		
		if game:Get("first_time_diner") == 1 and game:Get("talked_to_hal") ~= 1 then
			scene:Spawn(dinertoon3_spec);
		end
		
		if bernie_in_diner() then
			scene:Spawn(bernie_spec);
		end
		
		spawn_simple_hotspot("jukebox");
		spawn_simple_hotspot("clock");
		spawn_simple_hotspot("phone");
		spawn_simple_hotspot("pies");
		
		game:SetString("map_position", "m1_diner");
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces", -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		--{ "counter", 235 },

		{ "bench1", 380 },
		{ "bench2", 380 },
		{ "bench6", 380 },
		{ "bench3", 515 },
		{ "bench4", 515 },
		{ "bench5", 515 },
		{ "mask_table", 580 },

		{ "cash_register", 250 },
		{ "fishbowl", 195 },
		{ "ketchup", 200 },
		{ "pickle", 100 },
		{ "spinner", 140 },
		{ "tong", 130 },
		
		--{ "open_safe", 1 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },

	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		gran_spec,
		cookie_spec,
		coffee_pot_spec,
		mop_spec,
		drawer_spec,
		safe_spec,
		ambient2_spec,
		ambient1_spec,
		
		scene_setup,
	};
};
